<?php
/**
 * Main Plugin File
 *
 * @link              https://www.backlink-market.com
 * @since             1.0.0
 * @package           BLMKT_Connector
 *
 * @wordpress-plugin
 * Plugin Name:       Backlink Market Connector
 * Plugin URI:        https://www.backlink-market.com
 * Description:       Connects Wordpress to Backlink-Market.com.
 * Version:           1.0.1
 * Author:            Backlink Market
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       blmkt-connector
 * Domain Path:       /languages
 * download_url:      https://www.backlink-market.com/download-plugin
 */

require_once(__DIR__ . '/app/boot/bootstrap.php');

use BLMKT_Connector as BLMKT_Connector;
use BLMKT_Connector\App\Models\Settings as Settings_Model;
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

define('BLMKT_CONNECTOR_VERSION', '1.0.1');
define('BLMKT_CONNECTOR_FILE', __FILE__);
define('BLMKT_CONNECTOR_ROOT', __DIR__);
define('BLMKT_CONNECTOR_ROOT_URI', plugins_url('', __FILE__));
define('BLMKT_CONNECTOR_ASSET_URI', BLMKT_CONNECTOR_ROOT_URI . '/assets');

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// add auto plugin updater
$myUpdateChecker = PucFactory::buildUpdateChecker(
	'https://www.backlink-market.com/check-plugin-version', //'https://www.backlink-market.com/check-plugin-version
	__FILE__, //Full path to the main plugin file or functions.php.
	'backlink-market-connector'
);
/**
 * Creates/Maintains the object of Requirements Checker Class
 *
 * @return \BLMKT_Connector\Includes\Requirements_Checker
 * @since 1.0.0
 */
function blmkt_connector_requirements_checker() {
	static $requirements_checker = null;

	if ( null === $requirements_checker ) {
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-requirements-checker.php';
		$requirements_conf = apply_filters( 'blmkt_minimum_requirements', include_once( plugin_dir_path( __FILE__ ) . 'requirements-config.php' ) );
		$requirements_checker = new BLMKT_Connector\Includes\Requirements_Checker( $requirements_conf );
	}

	return $requirements_checker;
}

function blmkt_register_resource_item_featured_image_metadata() {
	register_meta(
		'post',
		'_blmkt_conn_enable_add_backlink',
		array(
			//'object_subtype' => 'optional', #omit unless you're dealing with a custom post type
			'show_in_rest' => true, #must be true to work in Guttenberg
			'type' => 'string',
			'single' => true,
            //'default' => 'active',
			'sanitize_callback' => 'rest_sanitize_string',
			'auth_callback' => function() {
				return current_user_can('edit_posts');
			}
		)
	);
	register_meta(
		'page',
		'_blmkt_conn_enable_add_backlink',
		array(
			//'object_subtype' => 'optional', #omit unless you're dealing with a custom post type
			'show_in_rest' => true, #must be true to work in Guttenberg
			'type' => 'string',
			'single' => true,
            //'default' => 'active',
            'sanitize_callback' => 'rest_sanitize_string',
            'auth_callback' => function () {
                return current_user_can('edit_posts');
            }
        )
    );
}

add_action('init', 'blmkt_register_resource_item_featured_image_metadata');

function blmkt_update_plugin_version_to_marketplace($upgrader_object, $options)
{
    $current_plugin_path_name = plugin_basename(__FILE__);
    if (isset($options['plugins']) && is_array($options['plugins'])) {
        foreach ($options['plugins'] as $each_plugin) {
            if ($each_plugin == $current_plugin_path_name) {
                $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
                $apiMarket->updatePluginVersionToMarket();
            }
        }
    } elseif (isset($options['plugins']) && ($options['plugins'] != "")) {
        if ($options['plugins'] == $current_plugin_path_name) {
            $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
            $apiMarket->updatePluginVersionToMarket();
        }
    } elseif (isset($options['plugin']) && ($options['plugin'] != "")) {
        if ($options['plugin'] == $current_plugin_path_name) {
            $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
            $apiMarket->updatePluginVersionToMarket();
        }
    }


}

add_action('upgrader_process_complete', 'blmkt_update_plugin_version_to_marketplace', 10, 2);
/**
 * Begins execution of the plugin.
 *
 * @since    1.0.0
 */
function blmkt_run_blmkt_connector()
{

    // If Plugins Requirements are not met.
    if (!blmkt_connector_requirements_checker()->requirements_met()) {
        add_action('admin_notices', array(blmkt_connector_requirements_checker(), 'show_requirements_errors'));

		// Deactivate plugin immediately if requirements are not met.
		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		deactivate_plugins( plugin_basename( __FILE__ ) );

		return;
	}

	/**
	 * The core plugin class that is used to define internationalization,
	 * admin-specific hooks, and frontend-facing site hooks.
	 */
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-blmkt-connector.php';

	/**
	 * Begins execution of the plugin.
	 *
	 * Since everything within the plugin is registered via hooks,
	 * then kicking off the plugin from this point in the file does
	 * not affect the page life cycle.
	 *
	 * @since    1.0.0
	 */
	$router_class_name = apply_filters( 'blmkt_connector_router_class_name', '\BLMKT_Connector\Core\Router' );
	$routes = apply_filters( 'blmkt_connector_routes_file', plugin_dir_path( __FILE__ ) . 'routes.php' );
	$GLOBALS['blmkt_connector'] = new BLMKT_Connector( $router_class_name, $routes );

	register_activation_hook( __FILE__, array( new BLMKT_Connector\App\Activator(), 'activate' ) );
	register_deactivation_hook( __FILE__, array( new BLMKT_Connector\App\Deactivator(), 'deactivate' ) );
}

blmkt_run_blmkt_connector();
