if(wp.element && wp.element.createElement) {
	var registerPlugin = wp.plugins.registerPlugin;
	var PluginPostStatusInfo = wp.editPost.PluginPostStatusInfo;
	var el = wp.element.createElement;
	var SelectControl = wp.components.SelectControl;
	var withSelect = wp.data.withSelect;
	var withDispatch = wp.data.withDispatch;

	var mapSelectToProps = function( select ) {
		return {
			IsEnableAddBacklink: select( 'core/editor' )
				.getEditedPostAttribute( 'meta' )['_blmkt_conn_enable_add_backlink'],
		}
	}

	var mapDispatchToProps = function( dispatch ) {
		return {
			enableAddBacklink: function( value ) {
				dispatch( 'core/editor' ).editPost(
					{ meta: { _blmkt_conn_enable_add_backlink: value } }
				);
			}
		}
	}

	var SelectIsEnableAddBacklink = function( props ) {
		return el( SelectControl, {
			label: 'Add to Backlink Market',
			value: props.IsEnableAddBacklink,
			onChange: function( content ) {
				props.enableAddBacklink( content );
			},
			options: [
                {value: 'active', label: 'Yes'},
                {value: 'inactive', label: 'No'}
            ]
		} );
	}

	var IsEnableAddBacklinkWithData = withSelect( mapSelectToProps )( SelectIsEnableAddBacklink );
	var IsEnableAddBacklinkWithDataAndActions = withDispatch( mapDispatchToProps )( IsEnableAddBacklinkWithData );

	registerPlugin( 'blmkt-conn', {
		render: function() {
			return el( PluginPostStatusInfo,
				{
					name: 'blmkt-conn',
					icon: 'admin-post',
					title: 'BLMKT Connector',
				},
				el( 'div',
					{ className: 'blmkt-connector' },
					el( IsEnableAddBacklinkWithDataAndActions )
				)
			);
		}
	} );
}
