<?php
namespace BLMKT_Connector\App\Controllers;

use BLMKT_Connector as BLMKT_Connector;
use BLMKT_Connector\Core\Controller;
use BLMKT_Connector\App\Models\Settings as Settings_Model;

require_once BLMKT_CONNECTOR_ROOT.'/api/MarketApiConnect.php';

if ( ! class_exists( __NAMESPACE__ . '\\' . 'Global_Actions' ) ) {
	/**
	 * Global Actions
	 *
	 * @since      1.0.0
	 * @package    BLMKT_Connector
	 * @subpackage BLMKT_Connector/controllers
	 */
    class Global_Actions extends Controller
    {

        public function __construct()
        {

        }

        /**
         * Register callbacks for actions and filters
         *
         * @since    1.0.0
         */
        public function register_hook_callbacks()
        {
            add_action('admin_enqueue_scripts', array($this, 'blmkt_enqueue_scripts'), 100);
            add_action('save_post', array($this, 'blmkt_update_custom_field_blmkt_conn_enable_add_backlink'));
            add_action('trash_post', array($this, 'blmkt_deactivate_page_in_marketplace'));
            add_action('trash_page', array($this, 'blmkt_deactivate_page_in_marketplace'));
            add_action('publish_post', array($this, 'blmkt_add_to_marketplace'));
            add_action('publish_page', array($this, 'blmkt_add_to_marketplace'));
            add_filter('the_content', array($this, 'blmkt_add_ordered_backlink'));
            add_action('admin_notices', array($this, 'blmkt_admin_notice_on_pending_verification'));
            add_action('activated_plugin', array($this, 'blmkt_activation_error'));


            add_action('rest_api_init', function () {
                register_rest_route('wp/v2', 'version-update-request', array(
                    'methods' => 'GET',
                    'callback' => array($this, 'version_update_request'),
                    'permission_callback' => function () {
                        return $this->blmkt_check_authkey() && $this->blmkt_check_ip();
                    }
                ));
            });
            add_action('rest_api_init', function () {
                register_rest_route('wp/v2', 'version', array(
                    'methods' => 'GET',
                    'callback' => array($this, 'blmkt_version'),
                    'permission_callback' => function () {
                        return $this->blmkt_check_authkey() && $this->blmkt_check_ip();
                    }
                ));
            });

            add_action('rest_api_init', function () {
                register_rest_route('wp/v2', 'get-posts-pages', array(
                    'methods' => 'GET',
                    'callback' => array($this, 'blmkt_getPagesPosts'),
                    'permission_callback' => function () {
                        return $this->blmkt_check_authkey() && $this->blmkt_check_ip();
                    }
                ));
            });
            add_action('rest_api_init', function () {
                register_rest_route('wp/v2', 'get-urls', array(
                    'methods' => 'GET',
                    'callback' => array($this, 'blmkt_getPagesPostsUrls'),
                    'permission_callback' => function () {
                        return $this->blmkt_check_authkey() && $this->blmkt_check_ip();
                    }
                ));
            });
            add_action('rest_api_init', function () {
                register_rest_route('wp/v2', 'verify-domain', array(
                    'methods' => 'GET',
                    'callback' => array($this, 'blmkt_verify_auth_key'),
                    'permission_callback' => function () {
                        return $this->blmkt_check_authkey() && $this->blmkt_check_ip();
                    }
                ));
            });
            add_action('rest_api_init', function () {
                register_rest_route('wp/v2', 'update-key', array(
                    'methods' => 'GET',
                    'callback' => array($this, 'blmkt_update_auth_key'),
                    'permission_callback' => function () {
                        return $this->blmkt_check_authkey() && $this->blmkt_check_ip();
                    }
                ));
            });
            add_action('rest_api_init', function () {
                register_rest_route('wp/v2', 'update-posts-pages-orders', array(
                    'methods' => 'POST',
                    'callback' => array($this, 'blmkt_update_posts_pages_orders'),
                    'permission_callback' => function () {
                        return $this->blmkt_check_authkey() && $this->blmkt_check_ip();
                    }
                ));
            });
            add_action('rest_api_init', function () {
                register_rest_route('wp/v2', 'first-sync', array(
                    'methods' => 'GET',
                    'callback' => array($this, 'blmkt_first_sync'),
                    'permission_callback' => function () {
                        return $this->blmkt_check_authkey() && $this->blmkt_check_ip();
                    }
                ));
            });

        }

     function version_update_request()
        {
            $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
            return $apiMarket->updatePluginVersionToMarket();
        }

        function blmkt_version()
        {
            return BLMKT_CONNECTOR_VERSION;
        }

        function blmkt_activation_error()
        {
            file_put_contents(plugin_dir_path(__FILE__) . '/error_activation.html', ob_get_contents());
        }

        function blmkt_check_authkey()
        {
            $headers = getallheaders();
            $key = "";
            $key = $headers['Siteauthkey'];

            if (strlen($key) > 1 && $key == Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY)) {
                return true;
            } else{
			return false;}
        }

        function blmkt_check_ip()
        {
            $allowedIp = BLMKT_Connector::BACKLINK_ALLOWED_IP;
            $testIP = '';

            if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $parts = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
                $testIP = trim($parts[0]);
            }

            if ($testIP === '127.0.0.1' || !filter_var($testIP, FILTER_VALIDATE_IP)) {
                $testIP = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '';
            }

            return filter_var($testIP, FILTER_VALIDATE_IP)
                    && filter_var($allowedIp, FILTER_VALIDATE_IP)
                    && $allowedIp === $testIP;
        }

        public function blmkt_getPagesPostsUrls($request_data)
        {
            $args = array(
                'numberposts' => -1,
                'post_status' => array('publish'),
                'meta_key' => '_blmkt_conn_enable_add_backlink',
                'meta_value' => 'active'
            );
            $response = array();
            $all_posts = get_posts($args);
            $i = 0;
            foreach ($all_posts as $all_post) {
                $response[] = get_permalink($all_post->ID);
            }

            $args = array(
                'number' => 0,
                'post_status' => array('publish')
            );
            $all_pages = get_pages($args);
            foreach ($all_pages as $all_page) {
                $response[] = get_permalink($all_page->ID);
            }
            return $response;
        }

        public function blmkt_getPagesPosts($request_data)
        {
            $args = array(
                'numberposts' => -1,
                'post_status' => array('publish'),
                'meta_key' => '_blmkt_conn_enable_add_backlink',
                'meta_value' => 'active'
            );
            $response = array();
            $all_posts = get_posts($args);
            $i = 0;
            foreach ($all_posts as $all_post) {
                $permalink = get_permalink($all_post->ID);
                if (rtrim($permalink, '/') === rtrim(home_url('/'), '/')) {
                    continue; // skip root domain
                }
                $response[$i]['ID'] = $all_post->ID;
                $response[$i]['url'] = get_permalink($all_post->ID);
                $response[$i]['type'] = "post";
                $response[$i]['title'] = get_the_title($all_post->ID);
                $response[$i]['publish_date'] = get_the_date('Y-m-d', $all_post->ID);
                $response[$i]['tags'] = get_the_tags($all_post->ID);
                $post_content = get_post_field('post_content', $all_post->ID);
                $response[$i]['content'] = $post_content;
                $i++;
            }

                  //Get all pages
                  $args = array(
                      'number' => 0,
                      'post_status' => array('publish')
                  );
                  $all_pages = get_pages($args);
                  foreach ($all_pages as $all_page) {
                      $permalink = get_permalink($all_page->ID);
                      if (rtrim($permalink, '/') === rtrim(home_url('/'), '/')) {
                          continue; // skip root domain
                      }
                          $response[$i]['ID'] = $all_page->ID;
                          $response[$i]['type'] = "page";
                          $response[$i]['title'] = get_the_title($all_page->ID);
                          $response[$i]['url'] = get_permalink($all_page->ID);
                          $response[$i]['publish_date'] = get_the_date('Y-m-d', $all_page->ID);
                          $response[$i]['tags'] = get_the_tags($all_page->ID);
                          $post_content = get_post_field('post_content', $all_post->ID);
                      $response[$i]['content'] = $post_content;
                      $i++;
                  }
			return $response;
		}



		public function blmkt_admin_notice_on_pending_verification(){
			if(empty(Settings_Model::get_setting( Settings_Model::BACKLINK_AUTH_KEY )) || Settings_Model::get_setting( Settings_Model::BACKLINK_AUTH_KEY )=="") {
                ?>
                <div class="notice notice-success is-dismissible">
                    <h2>Backlink Market Connector - Confirm your AuthKey</h2>
                    <p><?php _e('To start earning money with your blog, please add the Backlink Market AuthKey. You can find your key <a href="' . BLMKT_Connector::BACKLINK_MARKET_URL . '/seller_sites?confirm=' . urlencode(trailingslashit(get_option("siteurl"))) . '" target="_blank">here</a>', 'backlink-verification_notice'); ?></p>
                </div>
                <?php
            }
		}
        public function blmkt_update_auth_key($request_data){
            $parameters = $request_data->get_params();
			$response=array();
            if( strlen($parameters['new-auth-key'])>5){
                $apiMarket  = new \MarketApiConnect( BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting( Settings_Model::BACKLINK_AUTH_KEY ) );
                if ($apiMarket->updatePluginVersionToMarket() == true) {
                    Settings_Model::update_settings(array("blmkt_connector_auth_key" => $parameters['new-auth-key']));
                    $response['status'] = "success";
                } else {
                    $response['status'] = "forbid";
                }

            }else {
                 $response['status']="fail";
            }
			return $response;
        }

        public function blmkt_update_posts_pages_orders($request_data)
        {

            $parameters = $request_data->get_params();
            $response = array();
            $res = update_post_meta($parameters['content_id'], '_backlink_orders', $parameters['content']); //$params['content'][i]=link_content,promoted_url,anchor_text
            // $res is on new inset=db.id, on update = true, when already same content in db then false

            if ($res > 0 || $res==true) {
                $response['status'] = "success";
            } else {
                $response = ['status' => 'error', 'msg' => "Error Updating"];
            }
            return $response;

        }

        public function blmkt_first_sync()
        {
            if (Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY) != "") {
                //get all published posts
                $args = array(
                    'numberposts' => -1,
                    'post_status' => array('publish'),
                    'meta_key' => '_blmkt_conn_enable_add_backlink',
                    'meta_value' => 'active'
                );
                $response = array();
                $all_posts = get_posts($args);
                $i = 0;
                foreach ($all_posts as $all_post) {
                    $permalink = get_permalink($all_post->ID);
                      if (rtrim($permalink, '/') === rtrim(home_url('/'), '/')) {
                          continue; // skip root domain
                      }
                    $response[$i]['ID'] = $all_post->ID;
                    $response[$i]['url'] = get_permalink($all_post->ID);
                    $response[$i]['auth_key'] = Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY);
                    $response[$i]['site_url'] = get_option("siteurl");
                    $response[$i]['is_active'] = 1;
                    $post_content =  get_post_field('post_content', $all_post->ID);
                    $response[$i]['content'] = $post_content;
                    $response[$i]['title'] = get_the_title($all_post->ID);
                    $response[$i]['tags'] = get_the_tags($all_post->ID);
                    $response[$i]['type'] = "post";
                    $response[$i]['publish_date'] = get_the_date('Y-m-d', $all_post->ID);
                    $i++;
                }

                //Get all pages
                $args = array(
                    'number' => 0,
                    'post_status' => array('publish'),
                    'meta_key' => '_blmkt_conn_enable_add_backlink',
                    'meta_value' => 'active'
                );
                $all_pages = get_pages($args);
                foreach ($all_pages as $all_page) {
                    $permalink = get_permalink($all_page->ID);
                      if (rtrim($permalink, '/') === rtrim(home_url('/'), '/')) {
                          continue; // skip root domain
                      }
                    $response[$i]['ID'] = $all_page->ID;
                    $response[$i]['url'] = get_permalink($all_page->ID);
                    $response[$i]['auth_key'] = Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY);
                    $response[$i]['site_url'] = get_option("siteurl");
                    $response[$i]['is_active'] = 1;
                    $post_content = get_post_field('post_content', $all_page->ID);
                    $response[$i]['content'] = $post_content;
                    $response[$i]['title'] = get_the_title($all_page->ID);
                    $response[$i]['tags'] = get_the_tags($all_page->ID);
                    $response[$i]['type'] = "page";
                    $response[$i]['publish_date'] = get_the_date('Y-m-d', $all_page->ID);
                    $i++;
                }
            }
            $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
            $result_id = $apiMarket->addProductToMarketBulk($response);

            if ($result_id == 0) {
                $response = ['status' => 'error', 'msg' => "Error adding products to market"];
            }
            return $response;
        }

        public function blmkt_backlink_verify_sync_request($vars)
        {
            $vars[] .= 'backlink_verify_sync';
            return $vars;
        }


        public function blmkt_verify_auth_key($request_data)
        {
            $response['key'] = Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY);
            $response['site_url'] = get_option("siteurl");
            $response['plugin_version'] = $this->blmkt_version();
            return $response;
        }

        /* //Filter if settings changed to resync all pages and post
        public function plugin_setting_update($old_value, $new_value ){
            if($new_value['blmkt_connector_auth_key']!="" && $old_value['blmkt_connector_auth_key']!=$new_value['blmkt_connector_auth_key'])
            {
                $this->activate();
            }
        }
        */
        public function blmkt_add_to_marketplace($post_id)
        {
            //check if the post is in the database or not with get_post( $post_id ) == null
            if (get_post($post_id) == null) {
                return $post_id;
            }
            $post_raw_data = file_get_contents('php://input');
            $post_raw_data = @json_decode($post_raw_data, true);
            //$new value is "" when not manually changed. Else it will hold active or inactive when manually changed.
            $is_active = $post_raw_data['meta']['_blmkt_conn_enable_add_backlink'];
            if ($is_active == '' || $is_active == "active") {
                $is_active = 1;
            } elseif ($is_active == "inactive") {
                $is_active = 0;
            }
            $_blmkt_conn_enable_add_backlink = get_post_meta($post_id, '_blmkt_conn_enable_add_backlink', true);
            if ($_blmkt_conn_enable_add_backlink == '') { // when $_blmkt_conn_enable_add_backlink ='' its a brand new post
                // New post so transfer it to backlink market
                $post_raw_data = file_get_contents('php://input');
                $post_raw_data = @json_decode($post_raw_data, true);
                $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
                $post_content = get_post_field('post_content', $post_id);
                $result_id = $apiMarket->addProductToMarket($post_id, get_permalink($post_id), $is_active, $post_content, get_the_title($post_id), get_the_tags($post_id), get_post_type($post_id), get_the_date('Y-m-d', $post_id));
            }


        }

		public function blmkt_deactivate_page_in_marketplace($post_id)
        {
            //check if the post is in the database or not with get_post( $post_id ) == null
            if (get_post($post_id) == null) {
                return $post_id;
            }
            // Post is trashed so deactivate on backlink market
            $is_active = 0;
            $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
            $result_id = $apiMarket->updateProductStateToMarket($post_id, $is_active);
        }

		public function blmkt_save_post_on_activation( $post_id ) {
			//check if the post is in the database or not with get_post( $post_id ) == null
            if (get_post($post_id) == null) {
                return $post_id;
            }
            // check autosave
            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
                return $post_id;
            }
            $is_passed = false;
            $old_value = get_post_meta($post_id, '_blmkt_conn_enable_add_backlink', true);
            //checking if add to backlink is not inactive
            if ($old_value == "" || ($old_value != "" && $old_value == "active")) {
                $is_passed = true;
                update_post_meta($post_id, '_blmkt_conn_enable_add_backlink', "active");
            }
            ob_start();
            $debug_info = ob_get_clean();
            update_post_meta($post_id, 'debug_info', $debug_info);
				$is_active = ((get_post_meta( $post_id, '_blmkt_conn_enable_add_backlink', true ) == 'active') ? 1 : 0);
				$apiMarket  = new \MarketApiConnect( BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting( Settings_Model::BACKLINK_AUTH_KEY ) );
				$post_content=get_post_field('post_content', $post_id);
				$result_id = $apiMarket->addProductToMarket( $post_id, get_permalink($post_id), $is_active,$post_content,get_the_title($post_id),get_the_tags($post_id),get_post_type($post_id), get_the_date('Y-m-d', $post_id) );



				update_post_meta($post_id, 'debug_result', print_r($result_id, true));

        }

        public function blmkt_update_custom_field_blmkt_conn_enable_add_backlink($post_id)
        {
            //check if the post is in the database or not with get_post( $post_id ) == null
            if (get_post($post_id) == null) {
                return $post_id;
            }
            if (get_post_status($post_id) == 'publish') {
                // check autosave
                if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
                    return $post_id;
                }

                $old_value = get_post_meta($post_id, '_blmkt_conn_enable_add_backlink', true);

                $new_value = '';
                if (!empty($_POST)) {
                    $new_value = $_POST['_blmkt_conn_enable_add_backlink'];
                } else {
                    $post_raw_data = file_get_contents('php://input');
                    $post_raw_data = @json_decode($post_raw_data, true);
                    //$new value is "" when not manually changed. Else it will hold active or inactive when manually changed.
                    $new_value = $post_raw_data['meta']['_blmkt_conn_enable_add_backlink'];
                }

                if ($new_value && $new_value != $old_value) {
                    // value in db and different from new -> update to new value
                    $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
                    $result_id = $apiMarket->updateProductStateToMarket($post_id, $new_value);
                    update_post_meta($post_id, '_blmkt_conn_enable_add_backlink', $new_value);
                } else if (empty($new_value) && empty($old_value)) {
                    // New post and select not changed so its default (yes=active)
                    update_post_meta($post_id, '_blmkt_conn_enable_add_backlink', 'active');
                }

            }


		}

        public function blmkt_create_custom_field_to_post($post)
        {
            $post_id = get_the_ID();
            if (get_post_type($post_id) != 'post' && get_post_type($post_id) != 'page') {

            }

            wp_nonce_field('blmkt_conn_nonce_' . $post_id, 'blmkt_conn_nonce');
            $apiMarket = new \MarketApiConnect(BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting(Settings_Model::BACKLINK_AUTH_KEY));
            $result_id = $apiMarket->getProductStatusFromMarket($post_id);
            print_r($result_id);
            exit;
            ?>
            <div class="misc-pub-section misc-pub-section-last">
                <label>
                    <?php _e('Add to Backlink Market', BLMKT_Connector::PLUGIN_ID); ?>
                </label>
                <select name="_blmkt_conn_enable_add_backlink">
                    <option value="active" <?php ($enable_add_backlink != 'inactive') ? 'selected' : '' ?>>Yes</option>
                    <option value="inactive" <?php ($enable_add_backlink == 'inactive') ? 'selected' : '' ?>>No</option>
                </select>
            </div>
            <?php
        }

		/**
		 * Register the JavaScript for the admin area.
		 *
		 * @since    1.0.0
		 */
		public function blmkt_enqueue_scripts() {
			global $post;
			wp_enqueue_script(
				BLMKT_Connector::PLUGIN_ID . '_admin_post-js',
				BLMKT_Connector::get_plugin_url() . 'assets/js/admin/blmkt-connector-post.js',
				array( 'wp-edit-post', 'wp-plugins', 'wp-i18n', 'wp-element' ),
				BLMKT_Connector::PLUGIN_VERSION,
				true
			);

			/*$post_is_enable_add_backlink = 0;
			if( isset( $post->ID ) ) {
				$apiMarket  = new \MarketApiConnect( BLMKT_Connector::BACKLINK_MARKET_URL, Settings_Model::get_setting( Settings_Model::BACKLINK_AUTH_KEY ) );
				$post_is_enable_add_backlink = intval($apiMarket->getProductStatusFromMarket( $post->ID ));

				//$post_is_enable_add_backlink = intval(get_post_meta( $post->ID, '_blmkt_conn_enable_add_backlink', true ));

      }

			wp_localize_script( BLMKT_Connector::PLUGIN_ID . '_admin_post-js', 'blmkt_conn_post_vars', array(
				'post_id'                       => isset( $post->ID ) ? $post->ID : null,
                'post_is_enable_add_backlink'   => $post_is_enable_add_backlink,
            ));
			*/
		}

		public function blmkt_add_ordered_backlink( $content ) {
				global $post;
                $add_after_p=0;
				$backlink_orders=get_post_meta( $post->ID, '_backlink_orders', true );
				if($backlink_orders && $backlink_orders!=""){
					$backlink_orders =json_decode($backlink_orders);

					$total_p = substr_count( $content, '</p>' );
					$total_dot = substr_count( $content, '.' );
					$i=1;
					if($total_p>=count($backlink_orders)){
						foreach($backlink_orders as $backlink_order){
						//	$content_to_add="<span class='backlink-data'>";
                            $nofollow="";if($backlink_order->nofollow==1){$nofollow=' rel="nofollow"';}
                            $content_to_add = "<p>". preg_replace('/' . preg_quote($backlink_order->anchor_text,"/") . '/i', '<a href="' . $backlink_order->promoted_url . '"'.$nofollow.' target="_blank">' . $backlink_order->anchor_text . '</a>', $backlink_order->link_content, 1)."</p>";
						//	$content_to_add.="</span>";
							if(count($backlink_orders)==1)
								$add_after_p=floor($total_p/(count($backlink_orders)+1));
							else
								$add_after_p+=floor($total_p/(count($backlink_orders)));

							$content=$this->blmkt_prefix_insert_after_element($content_to_add,$add_after_p,$content,'</p>');
						}
					}
					else if($total_dot>=count($backlink_orders)){
						foreach($backlink_orders as $backlink_order){
							//$content_to_add="<span class='backlink-data'>";
                             $nofollow="";if($backlink_order->nofollow==1){$nofollow=' rel="nofollow"';}
							$content_to_add = "<p>". preg_replace('/' . preg_quote($backlink_order->anchor_text,"/") . '/i', '<a href="' . $backlink_order->promoted_url . '"'.$nofollow.' target="_blank">' . $backlink_order->anchor_text . '</a>', $backlink_order->link_content, 1)."</p>";
				        	//$content_to_add.="</span>";
							if(count($backlink_orders)==1)
								$add_after_p=floor($total_dot/(count($backlink_orders)+1));
							else
								$add_after_p+=floor($total_dot/(count($backlink_orders)));

							$content=$this->blmkt_prefix_insert_after_element($content_to_add,$add_after_p,$content,'.');
						}
					}
					else {
						//$content_to_add="<span class='backlink-data'>";
						foreach($backlink_orders as $backlink_order){
                          $nofollow="";if($backlink_order->nofollow==1){$nofollow=' rel="nofollow"';}
						 $content_to_add ="<p>". preg_replace('/' . preg_quote($backlink_order->anchor_text,"/") . '/i', '<a href="' . $backlink_order->promoted_url . '"'.$nofollow.' target="_blank">' . $backlink_order->anchor_text . '</a>', $backlink_order->link_content, 1)."</p>";
						}
						//$content_to_add.="</span>";
						$add_after_p=floor($total_p/2);

						$content=$this->blmkt_prefix_insert_after_element($content_to_add,$add_after_p,$content,'</p>');

					}

				}
			//	$content.="<style>span.backlink-data{display:block !important;text-align:center !important;padding: 15px 0px !important;}</style>";
        return $content;

		}

		public function blmkt_prefix_insert_after_element( $insertion, $paragraph_id, $content,$element ) {
			//$element = '</p>';
			$paragraphs = explode( $element, $content );

			if($paragraph_id>0){
				foreach ($paragraphs as $index => $paragraph) {
					if ( trim( $paragraph ) ) {
						$paragraphs[$index] .= $element;
					}
					if ( $paragraph_id == $index + 1 ) {
						$paragraphs[$index] .= $insertion;
					}
                }
                return implode('', $paragraphs);
            } else {
                $content .= $insertion;
            }
            return $content;
        }


    }


}

