<?php
namespace BLMKT_Connector\App\Controllers\Admin;

use BLMKT_Connector\App\Controllers\Admin\Base_Controller;
use BLMKT_Connector as BLMKT_Connector;

if ( ! class_exists( __NAMESPACE__ . '\\' . 'Admin_Menus' ) ) {

	/**
	 * Controller class that implements Plugin Admin Settings configurations
	 *
	 * @since      1.0.0
	 * @package    BLMKT_Connector
	 * @subpackage BLMKT_Connector/controllers/admin
	 */
	class Admin_Menus extends Base_Controller {

		/**
		 * Holds suffix for dynamic add_action called on settings page.
		 *
		 * @var string
		 * @since 1.0.0
		 */
		private static $hook_suffix = 'menus_page_' . BLMKT_Connector::PLUGIN_ID;

		/**
		 * Slug of the Settings Page
		 *
		 * @since    1.0.0
		 */
		const ORDERS_PAGE_SLUG = BLMKT_Connector::PLUGIN_ID.'-orders';

		/**
		 * Capability required to access settings page
		 *
		 * @since 1.0.0
		 */
		const REQUIRED_CAPABILITY = 'read';

		/**
		 * Register callbacks for actions and filters
		 *
		 * @since    1.0.0
		 */
		public function register_hook_callbacks() {
			// Create Menu.
			add_action( 'admin_menu', array( $this, 'blmkt_plugin_menu' ) );

			// Enqueue Styles & Scripts.
			add_action( 'admin_print_scripts-' . static::$hook_suffix, array( $this, 'blmkt_enqueue_scripts' ) );
			add_action( 'admin_print_styles-' . static::$hook_suffix, array( $this, 'blmkt_enqueue_styles' ) );
		}

		/**
		 * Create menu for Plugin inside Settings menu
		 *
		 * @since    1.0.0
		 */
		public function blmkt_plugin_menu() {
			// @codingStandardsIgnoreStart.
            add_menu_page(
                __( 'Backlinks', BLMKT_Connector::PLUGIN_ID ),
                __( 'Backlinks', '' ),
                static::REQUIRED_CAPABILITY,
                BLMKT_Connector::PLUGIN_ID,
                array($this, 'markup_orders_page'),
                'dashicons-editor-unlink',
                55 );

            add_submenu_page( BLMKT_Connector::PLUGIN_ID,
                __( 'Backlink orders', BLMKT_Connector::PLUGIN_ID ),
                __( 'Backlink orders', BLMKT_Connector::PLUGIN_ID ),
                static::REQUIRED_CAPABILITY,
                static::ORDERS_PAGE_SLUG, array($this, 'markup_orders_page') );
            remove_submenu_page( BLMKT_Connector::PLUGIN_ID, BLMKT_Connector::PLUGIN_ID );
			// @codingStandardsIgnoreEnd.
		}

		/**
		 * Register the JavaScript for the admin area.
		 *
		 * @since    1.0.0
		 */
		public function blmkt_enqueue_scripts() {

			/**
			 * This function is provided for demonstration purposes only.
			 */

			wp_enqueue_script(
				BLMKT_Connector::PLUGIN_ID . '_admin-js',
				BLMKT_Connector::get_plugin_url() . 'assets/js/admin/blmkt-connector.js',
				array( 'jquery' ),
				BLMKT_Connector::PLUGIN_VERSION,
				true
			);
		}

		/**
		 * Register the JavaScript for the admin area.
		 *
		 * @since    1.0.0
		 */
		public function blmkt_enqueue_styles() {


			wp_enqueue_style(
				BLMKT_Connector::PLUGIN_ID . '_admin-css',
				BLMKT_Connector::get_plugin_url() . 'assets/css/admin/blmkt-connector.css',
				array(),
				BLMKT_Connector::PLUGIN_VERSION,
				'all'
			);
		}

		/**
		 * Creates the markup for the Settings page
		 *
		 * @since    1.0.0
		 */
		public function markup_orders_page() {
            $default_views = array();
            $requested_view = isset( $_GET['view'] ) ? sanitize_text_field( $_GET['view'] ) : 'orders';
            if ( array_key_exists( $requested_view, $default_views ) && is_callable( $default_views[$requested_view] ) ) {

            } else {
                $this->view->order_list_page(
                    array(
                        'page_title'    => BLMKT_Connector::PLUGIN_NAME,
                        'page_slug'     => static::ORDERS_PAGE_SLUG,
                    )
                );
            }
		}
	}

}
