<?php
namespace BLMKT_Connector\App;

/**
 * Fired during plugin uninstallation.
 *
 * This class defines all code necessary to run during the plugin's uninstallation.
 *
 * @since      1.0.0
 * @package    BLMKT_Connector
 * @subpackage BLMKT_Connector/App
 */
class Uninstaller {

    /**
     * Run uninstall procedure.
     *
     * @since 1.0.0
     */
    public function uninstall() {
        global $wpdb;

        // delete order table
        $table_name = $wpdb->prefix . 'blmkt_connector_orders';
        $wpdb->query("DROP TABLE IF EXISTS $table_name");

        // delete post meta
        $meta_key = '_blmkt_conn_enable_add_backlink';
        $wpdb->query(
            $wpdb->prepare(
                "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s",
                $meta_key
            )
        );
    }
}
