<?php
namespace BLMKT_Connector\App;

use BLMKT_Connector\App\Models\Settings;

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    BLMKT_Connector
 * @subpackage BLMKT_Connector/App
 * @author     Backlink-Market <info@backlink-market.com>
 */
class Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
    public function activate() {

        // Init settings
        $this->initSettings();
        // Add meta field
        $this->add_meta_key();
    }

    /**
     * creates database tables
     */


    public function initSettings()
    {
        if (empty(Settings::get_setting(Settings::BACKLINK_AUTH_KEY))) {
            Settings::update_settings(array(
                Settings::BACKLINK_AUTH_KEY => ''
            ));
        }
    }

    public function add_meta_key()
    {
        //get all published posts
        $args = array(
            'numberposts' => -1,
            'post_status' => array('publish')
        );
        $all_posts = get_posts($args);
        $i = 0;
        foreach ($all_posts as $all_post) {
            update_post_meta($all_post->ID, '_blmkt_conn_enable_add_backlink', "active");
        }

        //Get all pages
        $args = array(
            'number' => 0,
            'post_status' => array('publish'),
        );
        $all_pages = get_pages($args);
        foreach ($all_pages as $all_page) {
            update_post_meta($all_page->ID, '_blmkt_conn_enable_add_backlink', "active");
        }
    }


}
