<?php

require_once __DIR__.'/MarketApiException.php';
require_once __DIR__.'/MarketApiBasic.php';

/**
 * contains function for connecting against blmkt-connect api
 * @author Patric Eid
 *
 */
class MarketApiConnect extends MarketApiBasic {
    private $api_url_product = "/api/v1/products";
    private $api_url_product_bulk = "/api/v1/products-bulk";
    private $api_url_change_product_state = "/api/v1/products/change-state";
    private $api_url_get_product_status = "/api/v1/products/product-status";
    private $api_url_get_ordered_backlink = "/api/v1/products/check-ordered";
    private $api_url_get_key_update_status = "/api/v1/site/check-key-update-status";
    private $api_url_update_plugin_version = "/api/v1/site/update-plugin-version";
    private $api_wp_site_url = "";
    private $api_auth_key = "";
	private $debugMode = false;

	function __construct($api_wp_site_url, $api_auth_key) {
	    $this->api_wp_site_url = $api_wp_site_url;
	    $this->api_auth_key = $api_auth_key;
	}

	/**
     * executes a get call
     * @param string $serviceUrl
     * @return string
     */
	private function _GET($serviceUrl) {
	    /*print_r(wp_remote_get(
            $serviceUrl,
            array('headers'=>$this->getHeader(),
                'method'=>'GET', 'timeout'=>60)
        )); exit;*/
	    return $this->setReturn(wp_remote_get(
            $serviceUrl,
            array(
                'headers'=>$this->getHeader(),
                'method'=>'GET',
                'timeout'=>60,
                'sslverify' => false)
        ));
    }

    /**
     * executes a POST call
     * @param string $serviceUrl
     * @param string $postData
     * @return string
     */
	private function _POST($serviceUrl, $postData) {
	    return $this->setReturn(wp_remote_post(
            $serviceUrl,
            array(
                'headers'=>$this->getHeader(),
                'body' => $postData,
                'method'=>'POST',
                'timeout'=>60,
                'sslverify' => false)
        ));
	}

    /**
     * executes a delete call
     * @param string $serviceUrl
     * @param string $postData
     * @return string
     */
	private function _DELETE($serviceUrl, $postData) {
		return $this->setReturn(wp_remote_post(
			$serviceUrl,
			array(
                'headers'=>$this->getHeader(),
                'body' => $postData,
				'method'=>'DELETE',
                'timeout'=>60,
                'sslverify' => false)
		));
	}

    /**
     * executes a put call
     * @param string $serviceUrl
     * @param string $postData
     * @return string
     */
	private function _PUT($serviceUrl, $postData) {
		return $this->setReturn(wp_remote_request(
				$serviceUrl,
				array('headers'=>$this->getHeader(),
                    'body' => $postData,
					'method'=>'PUT',
                    'timeout'=>60,
                    'sslverify' => false)
		));
	}

	/**
	 * returns headers array
	 * @return array
	 */
	private function getHeader() {
		return array(
            'Content-Type' => 'application/json; charset=UTF-8',
            'siteauthkey' => $this->api_auth_key,
            'siteurl' => get_option("siteurl")
        );
	}

    /**
     * evaluates call response and returns an array with response information
     * @param  $response
     * @return array|stdClass
     */
    private function setReturn($response) {

        if (is_wp_error($response)) {
            return $response->get_error_message();
        }else {
            return $response['body'];
        }
    }

    public function addProductToMarket( $page_id, $page_url, $is_active,$content="",$title="",$tags="",$post_type="",$publish_date="" )
    {
        $postData = array(
            'page_id' => $page_id,
            'page_url' => $page_url,
            'auth_key' => $this->api_auth_key,
            'site_url' => get_option("siteurl"),
            'is_active' => $is_active,
            'content' => $content,
            'title' => $title,
            'tags' => $tags,
            'type' => $post_type,
            'publish_date' => $publish_date
        );
        // Skip if root domain is same as url
        if (rtrim($page_url, '/') === rtrim(get_option("siteurl"), '/')) {
            return 0;
        }
        $postDataStr = json_encode($postData);
        $ret_data = $this->_POST($this->api_wp_site_url . $this->api_url_product, $postDataStr);
        $ret_data = json_decode($ret_data, true);
        if (isset($ret_data['product'])) {
            return $ret_data['product']['id'];
        } else {
            return 0;
        }
    }

    public function addProductToMarketBulk($data)
    {

        $postDataStr = json_encode($data);
        $ret_data = $this->_POST($this->api_wp_site_url . $this->api_url_product_bulk, $postDataStr);
        $ret_data = json_decode($ret_data, true);
        if (isset($ret_data['status']) && $ret_data['status'] == "success") {
            return $ret_data;
        } else {
            return 0;
        }
    }

    public function updateProductStateToMarket($page_id, $is_active)
    {
        $postData = array(
            'page_id' => $page_id,
            'auth_key' => $this->api_auth_key,
            'site_url' => get_option("siteurl"),
            'is_active' => $is_active,
        );
        $postDataStr = json_encode($postData);
        $ret_data = $this->_POST($this->api_wp_site_url . $this->api_url_change_product_state, $postDataStr);
        $ret_data = json_decode($ret_data, true);
        if(isset($ret_data['product'])) {
            return $ret_data['product']['id'];
        } else {
            return 0;
        }
    }

    public function getProductStatusFromMarket($page_id){
      $postData = array(
          'page_id' => $page_id,
          'auth_key' => $this->api_auth_key,
          'site_url' => get_option("siteurl"),
      );
      $postDataStr = json_encode($postData);
      $ret_data = $this->_POST( $this->api_wp_site_url . $this->api_url_get_product_status, $postDataStr);
      $ret_data = json_decode($ret_data, true);
      if(isset($ret_data['product']) && count($ret_data['product'])>0) {
          return $ret_data['product']['is_active'];
      } else {
          return 0;
      }
    }

    public function getBacklinkOrderContent($page_id){
      $postData = array(
          'page_id' => $page_id,
          'auth_key' => $this->api_auth_key,
          'site_url' => get_option("siteurl"),
      );
      $postDataStr = json_encode($postData);
      $ret_data = $this->_POST( $this->api_wp_site_url . $this->api_url_get_ordered_backlink, $postDataStr);
      $ret_data = json_decode($ret_data, true);
      if(isset($ret_data['content'])) {
          return $ret_data['content'];
      } else {
          return "";
      }
    }

    public function getIsUpdateAuthKeyAllowed(){
         $postData = array(
             'auth_key' => $this->api_auth_key,
             'site_url' => get_option("siteurl"),
         );
        $postDataStr = json_encode($postData);
        $ret_data = $this->_POST($this->api_wp_site_url . $this->api_url_get_key_update_status, $postDataStr);
        $ret_data = json_decode($ret_data, true);
        if (isset($ret_data['status']) && $ret_data['status'] == "allowed") {
            return true;
        } else {
            return false;
        }
    }

    public function updatePluginVersionToMarket()
    {
        $postData = array(
            'auth_key' => $this->api_auth_key,
            'site_url' => get_option("siteurl"),
            'plugin_version' => BLMKT_CONNECTOR_VERSION
        );
        $postDataStr = json_encode($postData);
        $ret_data = $this->_POST($this->api_wp_site_url . $this->api_url_update_plugin_version, $postDataStr);
        $ret_data = json_decode($ret_data, true);
        return $ret_data;

    }

}
