<?php
namespace BLMKT_Connector\App\Views\Admin;

use BLMKT_Connector\Core\View;
use BLMKT_Connector as BLMKT_Connector;

if ( ! class_exists( __NAMESPACE__ . '\\' . 'Admin_Settings' ) ) {
	/**
	 * View class to load all templates related to Plugin's Admin Settings Page
	 *
	 * @since      1.0.0
	 * @package    BLMKT_Connector
	 * @subpackage BLMKT_Connector/views/admin
	 */
	class Admin_Settings extends View {
		/**
		 * Prints Settings Page.
		 *
		 * @param  array $args Arguments passed by `markup_settings_page` method from `BLMKT_Connector\App\Controllers\Admin\Admin_Settings` controller.
		 * @return void
		 * @since 1.0.0
		 */
		public function admin_settings_page( $args = [] ) {
			echo $this->render_template(
				'admin/page-settings/page-settings.php',
				$args
			); // WPCS: XSS OK.
		}

		/**
		 * Prints Section's Description.
		 *
		 * @param  array $args Arguments passed by `markup_section_headers` method from  `BLMKT_Connector\App\Controllers\Admin\Admin_Settings` controller.
		 * @return void
		 * @since 1.0.0
		 */
		public function section_headers( $args = [] ) {
			echo $this->render_template(
				'admin/page-settings/page-settings-section-headers.php',
				$args
			); // WPCS: XSS OK.
		}

		/**
		 * Prints text field
		 *
		 * @param  array $args Arguments passed by `markup_fields` method from `BLMKT_Connector\App\Controllers\Admin\Admin_Settings` controller.
		 * @return void
		 * @since 1.0.0
		 */
		public function markup_text_fields( $args = [] ) {
			echo $this->render_template(
				'admin/page-settings/page-settings-text-fields.php',
				$args
			); // WPCS: XSS OK.
		}

		/**
		 * Prints checkbox field
		 *
		 * @param  array $args Arguments passed by `markup_fields` method from `BLMKT_Connector\App\Controllers\Admin\Admin_Settings` controller.
		 * @return void
		 * @since 1.0.0
		 */
		public function markup_checkbox_fields( $args = [] ) {
			echo $this->render_template(
				'admin/page-settings/page-settings-checkbox-fields.php',
				$args
			); // WPCS: XSS OK.
		}

        /**
         * Prints text field
         *
         * @param  array $args Arguments passed by `markup_fields` method from `BLMKT_Connector\App\Controllers\Admin\Admin_Settings` controller.
         * @return void
         * @since 1.0.0
         */
        public function markup_html_fields( $args = [] ) {
            echo $this->render_template(
                'admin/page-settings/page-settings-html-fields.php',
                $args
            ); // WPCS: XSS OK.
        }
	}
}
