<?php
namespace BLMKT_Connector\App;

use BLMKT_Connector\App\Models\Settings;

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    BLMKT_Connector
 * @subpackage BLMKT_Connector/App
 * @author     Backlink-Market <info@backlink-market.com>
 */
class Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
    public function activate() {
        // Remove MU-Plugin if it exists (from previous uninstall)
        $this->remove_shortcode_hider();

        // Init settings
        $this->initSettings();

        // Note: We no longer pre-populate meta keys on activation.
        // The helper function get_post_backlink_status() in Global_Actions uses lazy-loading.
        // This prevents timeout issues on sites with thousands of posts/pages.
    }

    /**
     * creates database tables
     */


    public function initSettings()
    {
        if (empty(Settings::get_setting(Settings::BACKLINK_AUTH_KEY))) {
            Settings::update_settings(array(
                Settings::BACKLINK_AUTH_KEY => ''
            ));
        }
    }


    /**
     * Remove the shortcode hider MU-Plugin.
     * This is called during plugin activation to restore functionality.
     *
     * @since 1.0.0
     */
    private function remove_shortcode_hider() {
        $mu_plugins_dir = WP_CONTENT_DIR . '/mu-plugins';
        $file_path = $mu_plugins_dir . '/blmkt-shortcode-hider.php';

        // Delete the file if it exists
        if (file_exists($file_path)) {
            @unlink($file_path);
        }
    }

}
